<?xml version="1.0" encoding="utf-8"?>
<!--
	EMREG v0.91 (PUBLIC DRAFT, CANDIDATE FOR 1.00)

	Copyright (C) 2025 Environment Agency Austria

	Commissioned by the Austrian Federal Ministry of Agriculture, Forestry, Regions and Water Management (BML)

	Licensed under the EUPL, Version 1.2 or – as soon they will be approved
	by the European Commission – subsequent versions of the EUPL (the "Licence");

	You may not use this work except in compliance with the Licence.

	You may obtain a copy of the Licence at: http://joinup.ec.europa.eu/software/page/eupl

	Unless required by applicable law or agreed to in writing, work distributed under the licence is distributed
	on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

	See the Licence for the specific language governing permissions and limitations under the Licence.
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:f="http://f.net/" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" queryBinding="xslt2">
	<sch:ns uri="http://www.umweltbundesamt.at/schema/EnvironmentalData" prefix="ed"/>
	<ns uri="http://f.net/" prefix="f"/>
	<!-- Dxx...allgemeine Datenformat-Bedingungen, Quelle: Datenformatausgestaltung und Rückmeldungen aus der Implementierung -->
	<!-- Sxx...allgemeine Datenformat-Bedingungen, Quelle: Anforderungsanalyse -->
	<!-- Klassifikation der Prüfungen -->
	<!--==============================-->
	<!-- _uqstrc .. Prüfung, dass sich gewisse Inhalte in Substruktur-Instanzen nicht wiederholen -->
	<!-- _uqelem .. Prüfung, dass sich gewisse Inhalte in simpleContent-Elementen nicht wiederholen -->
	<!-- _prvalw .. Prüfung, dass gewisse Inhalte vorhanden bzw. nicht sind (ohne Bedingungen, abgesehen von der Position im XML) -->
	<!-- _prvcdn .. Prüfung, dass gewisse Inhalte unter Bedingungen vorhanden bzw. nicht vorhanden sind -->
	<!-- _chkref .. Prüfung von Bezügen innerhalb der Dateninstanz -->
	<!-- _chkcon .. Prüfung der Konsistenz von verschiedenen Angaben -->
	<!-- _chkval .. Prüfung, dass nur vordefinierte Werte angegeben sind -->
	<!-- _chkmlt .. Prüfung der Multiplizität -->
	<xsl:function name="f:isPhProperty" as="xs:boolean">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:choose>
				<xsl:when test="$spropid eq '9008390115756'">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:when test="contains($spropid,'_vNKN')">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="false()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:sequence>
	</xsl:function>
	<xsl:function name="f:isTemperatureProperty" as="xs:boolean">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:choose>
				<xsl:when test="$spropid eq '9008390115961'">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:when test="contains($spropid,'_vHGE')">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="false()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:sequence>
	</xsl:function>
	<xsl:function name="f:strippedParamID" as="xs:string">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:value-of select="if (contains($spropid,'_')) then (substring(replace(concat('_', $spropid), '_[^stv][A-Z]+', ''),2)) else ($spropid)"/>
		</xsl:sequence>
	</xsl:function>
	<xsl:function name="f:isInclMasterData" as="xs:boolean">
		<xsl:param name="nroot" as="node()"/>
		<xsl:sequence>
			<xsl:value-of select="if (exists($nroot/descendant::ListedData/Installation/*[(local-name() ne 'DocumentScopeAssignmentID') and (local-name() ne 'ID') and (local-name() ne 'Name') and (local-name() ne 'AuthorityAssignedName')])) then (true()) else (false())"/>
		</xsl:sequence>
	</xsl:function>
	<pattern>
		<rule id="R122" context="ListedData">
			<report id="R122_uqstrc" role="WARNING" test="count(distinct-values(*/ID/concat(.,',',@collectionID))) ne count(*/ID/concat(.,',',@collectionID))">IDs haben den Aufzählungen von Anlagen, Teilströmen, usw. in ListedData nicht mehrfach zugeordnet zu sein - verletzt für IDs <sch:value-of select="string-join((for $m in distinct-values(*/ID/concat(.,',',@collectionID)) return if (count(*/ID[(. eq tokenize($m,',')[1]) and (@collectionID eq tokenize($m,',')[2])]) ge 2) then tokenize($m,',')[1] else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R141" context="ListedData/Organization">
			<report id="R141_prvalw" role="ERROR" test="not(exists(ID[(@collectionID='9008390104026') or (@collectionID='9008390104040') or (@collectionID='9008390104057') or (@collectionID='9008390104064')]))">Zu jeder nicht-natürlichen Person hat eine EDM-Personen-GLN, Firmenbuchnummer, Vereinsregisternummer oder Ergänzungsregisternummer angegeben zu sein - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Person<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R161" context="ListedData/Organization">
			<report id="R161_chkref" role="ERROR" test="some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'PartyReferenceID') and (text() eq $m)]) lt 1">Auf jede (nicht-natürliche) Person hat in der Dateninstanz Bezug genommen zu werden - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Person<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R166" context="ListedData/Organization">
			<report id="R166_uqstrc" role="ERROR" test="count(distinct-values(CommunicationNetworkEndpoint/TypeID)) ne count(CommunicationNetworkEndpoint/TypeID)">Je Kontaktart (Website-Adresse, Telefon, usw.) hat nicht mehr als eine Kontaktinformation angegeben zu werden (Element CommunicationNetworkEndpoint) - verletzt für Kontaktangaben zur <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Person<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R202" context="Document/TypeID">
			<report id="R202_chkval" role="ERROR" test="current()/text() eq '9008390120507'">Die XML-Dateninstanz enthält als Dokumentart-Angabe den Wert »9008390120507« für »Wasserwirtschaftliche Stammdaten und Bewegungsdaten«. Seit v0.33 der Datenformat-Spezifikation unterstützt das Datenformat nur noch die Dokument-Art »9008390120514« für »Wasserwirtschaftliche Bewegungsdaten«. Seit 2024 unterstützt die EMREG-OW-Anwendung die XML-Übermittlung von wasserwirtschaftlichen Stammdaten an die Bundesbehörde NICHT mehr.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R217" context="ListedData/Installation">
			<report id="R217_prvalw" role="ERROR" test="(count(ID) lt 1)">Zu jeder Anlage hat zumindest eine Identifikationszeichenkette im Element ID angegeben zu sein - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Anlage<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R336" context="ListedData/WasteWaterStream">
			<assert id="R336_prvalw" role="ERROR" test="exists(ID[@collectionID='9008390108260'])">Zu jedem Teilstrom hat eine Wasserbuch-ID angegeben zu sein - verletzt für den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</assert>
		</rule>
	</pattern>
	<pattern>
		<rule id="R352" context="ListedData/WasteWaterStream">
			<report id="R352_chkref" role="ERROR" test="some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'WasteWaterStreamReferenceID') and (text() eq $m)]) lt 1">Auf jeden Teilstrom hat in der Dateninstanz Bezug genommen zu werden - verletzt für den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R497" context="EnvironmentalData/InstallationReferencePeriodResult">
			<report id="R497_prvalw" role="ERROR" test="count(InstallationReferenceID) lt 1">Die Bezugszeitraum-spezifischen Angaben zu einer Anlage in InstallationReferencePeriodResult haben den Bezug auf eine Anlage im Element InstallationReferenceID zu enthalten - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Bezugszeitraum-Angaben (InstallationReferencePeriodResult) innerhalb der <sch:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R520" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult">
			<report id="R520_prvalw" role="ERROR" test="count(WasteWaterStreamReferenceID) lt 1">Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Eigenschaften in WasteWaterStreamReferencePeriodResult haben den Bezug auf einen Teilstrom im Element WasteWaterStreamReferenceID zu enthalten - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Bezugszeitraum-Angaben (WasteWaterStreamReferencePeriodResult) innerhalb der <sch:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R522" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult">
			<report id="R522_uqstrc" role="ERROR" test="count(distinct-values(EffluentWaterParameterProperty/PropertyKindID)) ne count(EffluentWaterParameterProperty/PropertyKindID)">Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Abfluss-Eigenschaften in WasteWaterStreamReferencePeriodResult haben zu jedem Parameter höchstens einen Eintrag zu enthalten - verletzt für Abfluss-Bezugszeitraumangaben zu Parametern mit den IDs <sch:value-of select="string-join((for $m in distinct-values(EffluentWaterParameterProperty/PropertyKindID) return if (count(EffluentWaterParameterProperty[PropertyKindID eq $m]) ge 2) then $m else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R523" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult">
			<report id="R523_uqstrc" role="ERROR" test="count(distinct-values(InfluentWaterParameterProperty/PropertyKindID)) ne count(InfluentWaterParameterProperty/PropertyKindID)">Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Zufluss-Eigenschaften in WasteWaterStreamReferencePeriodResult haben zu jedem Parameter höchstens einen Eintrag zu enthalten - verletzt für Zufluss-Bezugszeitraumangaben zu Parametern mit den IDs <sch:value-of select="string-join((for $m in distinct-values(InfluentWaterParameterProperty/PropertyKindID) return if (count(InfluentWaterParameterProperty[PropertyKindID eq $m]) ge 2) then $m else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R531" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty">
			<report id="R531_chkcon" role="ERROR" test="some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(TestingCount)">Für jeden Teilstrom und jeden Parameter in den Bewegungsdaten muss zutreffen, dass den Abfluss betreffend nicht sowohl die Anzahl der Einzelmesswerte angegeben ist (TestingCount-Element), als auch die Einzelmesswerte selbst (PropertyTesting-Element) - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den Parameter mit der ID »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R532" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty">
			<report id="R532_chkcon" role="ERROR" test="some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(ValueAssignmentStatement)">Für jeden Teilstrom und jeden Parameter in den Bewegungsdaten muss zutreffen, dass den Abfluss betreffend nicht sowohl Bezugszeitraum-Angaben enthalten sind (EffluentWaterParameterProperty-Element mit ValueAssignmentStatement-Unterelement), als auch Einzelmesswerte (PropertyTesting-Element) - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den Parameter mit der ID »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R538" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty">
			<report id="R538_prvalw" role="ERROR" test="not(exists(PropertyCategoryID))">Für den Abfluss betreffende Bezugszeitraum-Werte hat die Parameterkategorie (PropertyCategoryID-Element) angegeben zu sein - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Abfluss angegebenen Parameter (ID: »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R542" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty">
			<report id="R542_prvcdn" role="ERROR" test="not(exists(ValueAssignmentStatement)) and exists(../WasteWaterStreamReferenceID) and not(exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentSampleTestingEvent[f:strippedParamID(PropertyTesting/PropertyKindID) eq f:strippedParamID(current()/PropertyKindID)]))">Für den Abfluss betreffende Bezugszeitraum-Angaben haben Werte angegeben zu sein (ValueAssignmentStatement-Element) sofern zum betreffenden Teilstrom und Parameter keine Einzeluntersuchungsergebnisse vorhanden sind - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Abfluss angegebenen Parameter (ID: »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R569" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty">
			<report id="R569_prvalw" role="ERROR" test="exists(PropertyCategoryID)">Für den Zufluss betreffende Bezugszeitraum-Werte hat die Parameterkategorie (PropertyCategoryID-Element) nicht angegeben zu sein - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R593" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty">
			<report id="R593_prvalw" role="ERROR" test="not(exists(ValueAssignmentStatement))">Für den Zufluss betreffende Bezugszeitraum-Angaben haben Werte angegeben zu sein (ValueAssignmentStatement-Element) - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R595" context="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty">
			<report id="R595_prvalw" role="ERROR" test="exists(CalculationBasisPeriod)">Für den Zufluss betreffende Bezugszeitraum-Werte hat kein Berechnungsbasis-Messjahr (CalculationBasisPeriod-Element) angegeben zu sein - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R597" context="WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]">
			<report id="R597_prvcdn" role="ERROR" test="(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())">Das Datenformat unterstützt die Angabe von Werten für den gesamten Bezugszeitraum nur für solche Parameter, bei welchen es sich weder um “pH-Wert” noch um “Temperatur” handelt - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zu diesem Teilstrom bezogen auf den <sch:value-of select="if (ends-with(local-name(), 'EffluentWaterParameterProperty')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R604" context="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod">
			<report id="R604_chkval" role="ERROR" test="some $m in StartDate satisfies day-from-date($m) ne 1 or month-from-date($m) ne 1">Der <sch:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat mit einem 1. Jänner zu beginnen - verletzt für Beginndatum »<sch:value-of select="StartDate"/>«.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R608" context="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod">
			<report id="R608_chkval" role="ERROR" test="some $m in EndDate satisfies day-from-date($m) ne 31 or month-from-date($m) ne 12">Der <sch:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat mit einem 31. Dezember zu enden - verletzt für Enddatum »<sch:value-of select="EndDate"/>«.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R610" context="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod">
			<report id="R610_chkval" role="ERROR" test="if (exists(StartDate) and exists(EndDate)) then (year-from-date(EndDate) ne year-from-date(StartDate)) else false()">Der <sch:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat sich nicht über ein Kalenderjahr hinaus zu erstrecken - verletzt für den Zeitraum »<sch:value-of select="StartDate"/> bis <sch:value-of select="EndDate"/>«.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R692" context="*[(ends-with(local-name(), 'Address') and Component)]">
			<report id="R692_uqstrc" role="ERROR" test="count(distinct-values(Component/TypeID)) ne count(Component/TypeID)">In Adressangaben hat keine der Adresskomponenten (“Straße”, “Postleitzahl”, usw.) mehrfach vorzukommen - verletzt für Adress-Element »<sch:value-of select="local-name(.)"/>« in »<sch:value-of select="local-name(parent::*)"/>«.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R694" context="*[ends-with(local-name(), 'Address')]/Component">
			<report id="R694_chkcon" role="ERROR" test="TypeID ne '9008390104682' and exists(ID)">Die Identifikation einer Adresskomponente per ID-Element wird nur für die Adresskomponente “Land” (GTIN 9008390104682) unterstützt - verletzt für die Adresskomponente des Typs mit der GTIN »<sch:value-of select="TypeID"/>«<sch:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R707" context="*[ends-with(local-name(), 'Address')]/Component">
			<report id="R707_chkcon" role="ERROR" test="exists(RepresentationID) and (TypeID ne '9008390103975' and TypeID ne '9008390103999' and TypeID ne '9008390104002' and TypeID ne '9008390104019' and TypeID ne '9008390103944')">Das Datenformat unterstützt das Element RepresentationID ausschließlich in Adresskomponenten der Typen Hausnummer (GTIN 9008390103975), Stiege (GTIN 9008390103999), Stock (GTIN 9008390104002), Türnummer (GTIN 9008390104019) und Postleitzahl (GTIN 9008390103944) - verletzt für die Adresskomponente des Typs mit der GTIN »<sch:value-of select="TypeID"/>«<sch:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R712" context="*[ends-with(local-name(), 'Address')]/Component">
			<report id="R712_chkcon" role="ERROR" test="exists(RepresentationDesignation) and (TypeID ne '9008390103968' and TypeID ne '9008390103951' and TypeID ne '9008390104682')">Das Datenformat unterstützt das Element RepresentationDesignation ausschließlich in Adresskomponenten der Typen Straße (GTIN 9008390103968), Ort (GTIN 9008390103951) und Land (GTIN 9008390104682) - verletzt für die Adresskomponente des Typs mit der GTIN »<sch:value-of select="TypeID"/>«<sch:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R767" context="EnvironmentalData">
			<report id="R767_uqstrc" role="ERROR" test="count(distinct-values(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)) ne count(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)">Die Bezugszeitraum-Angaben in WasteWaterStreamReferencePeriodResult haben nach Teilstrom gruppiert zu sein, d.h. auf denselben Teilstrom hat nicht mehrfach Bezug genommen zu werden - verletzt für Zeitraum-Angaben mit Bezug auf Teilströme mit Wasserbuch-IDs <sch:value-of select="string-join((for $m in distinct-values(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID) return if (count(WasteWaterStreamReferencePeriodResult[WasteWaterStreamReferenceID eq $m]) ge 2) then ancestor::*/ListedData/WasteWaterStream[DocumentScopeAssignmentID eq $m]/ID[@collectionID eq '9008390108260'] else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<!-- new pattern for preventing useless validation report entry repetitions, as used in PACK3: Inform about the first occurrence triggering the specific issue - provides useful XPath information in contrast to the previous "summary id list" approach -->
	<pattern>
		<rule id="R808" context="EnvironmentalData/Testing/TestingEvent[exists(WasteWaterStreamReferenceID)]/EffluentSampleTestingEvent[not(f:isPhProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(f:isTemperatureProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(exists(preceding-sibling::EffluentSampleTestingEvent[PropertyTesting/PropertyKindID/text() eq current()/PropertyTesting/PropertyKindID/text()]))]">
			<report id="R808_prvcdn" role="ERROR" test="not(exists(../../../WasteWaterStreamReferencePeriodResult[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentWaterParameterProperty[(f:strippedParamID(PropertyKindID) eq f:strippedParamID(current()/PropertyTesting/PropertyKindID)) and (count(PropertyCategoryID) gt 0)]))">Für jeden Abfluss-Einzelmesswert hat über in Bezug auf Teilstrom und Parameter <sch:value-of select="f:strippedParamID(PropertyTesting/PropertyKindID/text())"/> korrespondierende Bezugszeitraum-Angaben (WasteWaterStreamReferencePeriodResult) die Parameterkategorie im Element PropertyCategoryID angegeben zu sein - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den Abfluss angegebenen Parameter mit der ID »<sch:value-of select="PropertyTesting/PropertyKindID"/>«<sch:value-of select="if (exists(PropertyTesting/PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyTesting/PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R809" context="Testing/TestingEvent">
			<report id="R809_chkmlt" role="ERROR" test="some $m in distinct-values(EffluentSampleTestingEvent/PropertyTesting/PropertyKindID) satisfies count(EffluentSampleTestingEvent[PropertyTesting/PropertyKindID eq $m]) gt 12">Das Datenformat unterstützt die Angabe von nicht mehr als 12 Abfluss-Einzelmesswerten pro Berichtsjahr, Teilstrom und Parameter - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und die Parameter mit den IDs <sch:value-of select="string-join((for $m in distinct-values(EffluentSampleTestingEvent/PropertyTesting/PropertyKindID) return if (count(EffluentSampleTestingEvent[PropertyTesting/PropertyKindID eq $m]) gt 12) then tokenize($m,',')[1] else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R828" context="Testing/TestingEvent">
			<report id="R828_chkcon" role="ERROR" test="InfluentSampleTestingEvent">Das Datenformat unterstützt die Übermittlung von einzelnen Untersuchungsergebnissen nur für den Abfluss - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den zu diesem Teilstrom angegebenen Zufluss-Parametern.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R832" context="Testing/TestingEvent">
			<report id="R832_prvalw" role="ERROR" test="count(WasteWaterStreamReferenceID) lt 1">Die Angaben zu den einzelnen Wasseruntersuchungen und deren Ergebnissen haben den Bezug auf einen Teilstrom im Element WasteWaterStreamReferenceID zu enthalten - verletzt für die <sch:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Untersuchungsergebnis-Angaben (TestingEvent) innerhalb der <sch:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R874" context="EnvironmentalData/Testing">
			<report id="R874_prvalw" role="ERROR" test="count(AppliedMethod) ge 1">Bei der Übermittlung in EMREG-OW wird für Einzelmesswerte eine Angabe von Methoden nicht unterstützt.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R875" context="EnvironmentalData/Testing">
			<report id="R875_uqstrc" role="ERROR" test="count(distinct-values(TestingEvent/WasteWaterStreamReferenceID)) ne count(TestingEvent/WasteWaterStreamReferenceID)">Die Angaben zu einzelnen Untersuchungen in Testing/TestingEvent haben nach Teilstrom gruppiert zu sein, d.h. auf denselben Teilstrom hat nicht mehrfach Bezug genommen zu werden - verletzt für Untersuchungsangaben mit Bezug auf Teilströme mit Wasserbuch-IDs <sch:value-of select="string-join((for $m in distinct-values(TestingEvent/WasteWaterStreamReferenceID) return if (count(TestingEvent[WasteWaterStreamReferenceID eq $m]) ge 2) then ancestor::*/ListedData/WasteWaterStream[DocumentScopeAssignmentID eq $m]/ID[@collectionID eq '9008390108260'] else '')[. != ''], ', ')"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R909" context="TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting">
			<report id="R909_chkcon" role="ERROR" test="(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())">Das Datenformat unterstützt die Übermittlung von einzelnen Untersuchungsergebnissen in EMREG-OW nur für solche Parameter, bei welchen es sich weder um “pH-Wert” noch um “Temperatur” handelt - verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den <sch:value-of select="if (ends-with(local-name(..), 'EffluentSampleTestingEvent')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R916" context="TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting">
			<report id="R916_chkval" role="ERROR" test="(count(ValueAssignmentStatement/NumericValue[not(exists(@unitID))]) ge 1) or (some $m in ValueAssignmentStatement/NumericValue/@unitID satisfies (($m ne 'mg/l') and ($m ne 'ug/l') and ($m ne 'ng/l')))">Das Datenformat unterstützt die für die Übermittlung von Untersuchungsergebnissen in die Anwendung EMREG-OW ausschließlich die Angabe der Größeneinheiten “mg/l”, “µg/l” bzw. “ng/l”- verletzt für den <sch:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<sch:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den <sch:value-of select="if (ends-with(local-name(..), 'EffluentSampleTestingEvent')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<sch:value-of select="PropertyKindID"/>«<sch:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R948" context="ed:EnvironmentalDataEnvelope">
			<report id="R948_chkmlt" role="ERROR" test="count(EnvironmentalDataDocument) ne 1">Der Datenimport in EMREG-OW ist jeweils nur für genau ein Berichtsjahr möglich, und somit jeweils genau ein EnvironmentalDataDocument-Element. Es sind jedoch <sch:value-of select="count(EnvironmentalDataDocument)"/> EnvironmentalDataDocument-Elemente in der Dateninstanz enthalten.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R956" context="ed:EnvironmentalDataEnvelope">
			<report id="R956_chkcon" role="ERROR" test="count(distinct-values(//PropertyKindID/@collectionID)) gt 1">Innerhalb einer XML-Dateninstanz haben alle Parameter entweder per EHPC-Code (Codeliste 6912) oder per GTIN (Codeliste 2809) angegeben zu sein, und zwar über die verschiedenen Angaben - z.B. Grenzwert, Jahreswert, Messwert - hinweg. Das “Mischen” von EHPC-Codes und GTINs innerhalb einer XML-Dateninstanz wird vom Datenformat nicht unterstützt.</report>
		</rule>
	</pattern>
	<pattern>
		<rule id="R978" context="//*[ends-with(local-name(), 'ID') and (count(preceding-sibling::*[name() eq name(current())]) eq 0)]">
			<report id="R978_uqelem" role="ERROR" test="(not(ends-with(local-name(), 'ReferenceID'))) and (local-name() ne 'AuthorityAssignedID') and (local-name() ne 'CadastralParcelID') and (local-name() ne 'CadastralPropertyID') and (local-name() ne 'SewageTreatmentStageID') and (local-name() ne 'MunicipalityID') and (local-name() ne 'OriginInstallationIPPCActivityID') and (local-name() ne 'OriginInstallationActivityID') and (local-name() ne 'ActivityID') and (local-name() ne 'LegalBasisID') and (local-name() ne 'CadastralMunicipalityID') and (count(distinct-values(../*[name() eq name(current())]/@collectionID)) ne count(../*[name() eq name(current())]/@collectionID))">Bei wiederholbaren ID-Elementen ist in vielen Fällen nur ein Eintrag pro Codeliste bzw. Sammlung von Identifikatoren zulässig - verletzt für Element »<sch:value-of select="local-name(.)"/>« in »<sch:value-of select="local-name(parent::*)"/>«.</report>
		</rule>
	</pattern>
</schema>
