<?xml version="1.0" encoding="utf-8"?>
<!--
	EMREG v0.91 (PUBLIC DRAFT, CANDIDATE FOR 1.00)

	Copyright (C) 2025 Environment Agency Austria

	Commissioned by the Austrian Federal Ministry of Agriculture, Forestry, Regions and Water Management (BML)

	Licensed under the EUPL, Version 1.2 or – as soon they will be approved
	by the European Commission – subsequent versions of the EUPL (the "Licence");

	You may not use this work except in compliance with the Licence.

	You may obtain a copy of the Licence at: http://joinup.ec.europa.eu/software/page/eupl

	Unless required by applicable law or agreed to in writing, work distributed under the licence is distributed
	on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

	See the Licence for the specific language governing permissions and limitations under the Licence.
-->
<xsl:transform xmlns:ed="http://www.umweltbundesamt.at/schema/EnvironmentalData" xmlns:error="https://doi.org/10.5281/zenodo.1495494#error" xmlns:f="http://f.net/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:schxslt="https://doi.org/10.5281/zenodo.1495494" xmlns:schxslt-api="https://doi.org/10.5281/zenodo.1495494#api" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<rdf:Description xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dct="http://purl.org/dc/terms/" xmlns:skos="http://www.w3.org/2004/02/skos/core#">
		<dct:created>2025-11-19T10:04:21.2047498+01:00</dct:created>
	</rdf:Description>
	<xsl:output indent="yes"/>
	<xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" name="f:isPhProperty" as="xs:boolean">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:choose>
				<xsl:when test="$spropid eq '9008390115756'">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:when test="contains($spropid,'_vNKN')">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="false()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:sequence>
	</xsl:function>
	<xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" name="f:isTemperatureProperty" as="xs:boolean">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:choose>
				<xsl:when test="$spropid eq '9008390115961'">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:when test="contains($spropid,'_vHGE')">
					<xsl:value-of select="true()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="false()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:sequence>
	</xsl:function>
	<xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" name="f:strippedParamID" as="xs:string">
		<xsl:param name="spropid" as="xs:string"/>
		<xsl:sequence>
			<xsl:value-of select="if (contains($spropid,'_')) then (substring(replace(concat('_', $spropid), '_[^stv][A-Z]+', ''),2)) else ($spropid)"/>
		</xsl:sequence>
	</xsl:function>
	<xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" name="f:isInclMasterData" as="xs:boolean">
		<xsl:param name="nroot" as="node()"/>
		<xsl:sequence>
			<xsl:value-of select="if (exists($nroot/descendant::ListedData/Installation/*[(local-name() ne 'DocumentScopeAssignmentID') and (local-name() ne 'ID') and (local-name() ne 'Name') and (local-name() ne 'AuthorityAssignedName')])) then (true()) else (false())"/>
		</xsl:sequence>
	</xsl:function>
	<xsl:template match="/">
		<xsl:variable name="metadata" as="element()?">
			<svrl:metadata xmlns:dct="http://purl.org/dc/terms/" xmlns:skos="http://www.w3.org/2004/02/skos/core#" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
				<dct:created>
					<xsl:value-of select="current-dateTime()"/>
				</dct:created>
				<dct:source>
					<rdf:Description xmlns:dc="http://purl.org/dc/elements/1.1/">
						<dct:created>2025-11-19T10:04:21.2047498+01:00</dct:created>
					</rdf:Description>
				</dct:source>
			</svrl:metadata>
		</xsl:variable>
		<xsl:variable name="report" as="element(schxslt:report)">
			<schxslt:report>
				<xsl:call-template name="d17e103"/>
			</schxslt:report>
		</xsl:variable>
		<xsl:variable name="schxslt:report" as="node()*">
			<xsl:for-each select="$report/schxslt:pattern">
				<xsl:sequence select="$report/schxslt:rule[@pattern = current()/@id]/node()[(local-name() eq 'successful-report') or (local-name() eq 'failed-assert')]"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="schxslt:report_fin" as="node()*">
			<xsl:for-each-group xmlns:svrl="http://purl.oclc.org/dsdl/svrl" select="$schxslt:report" group-by="concat(local-name(), '|', string(svrl:text), '|', string-join(@*[(local-name() ne 'test') and (local-name() ne 'location')],'|'), '|', string-join(svrl:property-reference/svrl:text,'|'))">
				<xsl:copy-of select="."/>
			</xsl:for-each-group>
		</xsl:variable>
		<svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
			<svrl:ns-prefix-in-attribute-values prefix="ed" uri="http://www.umweltbundesamt.at/schema/EnvironmentalData"/>
			<svrl:ns-prefix-in-attribute-values prefix="f" uri="http://f.net/"/>
			<svrl:active-pattern/>
			<xsl:sequence select="$schxslt:report_fin"/>
		</svrl:schematron-output>
	</xsl:template>
	<xsl:template match="text() | @*" mode="#all" priority="-10"/>
	<xsl:template match="*" mode="#all" priority="-10">
		<xsl:apply-templates mode="#current" select="@*"/>
		<xsl:apply-templates mode="#current" select="node()"/>
	</xsl:template>
	<xsl:template name="d17e103">
		<schxslt:pattern id="d17e103"/>
		<schxslt:pattern id="d17e114"/>
		<schxslt:pattern id="d17e128"/>
		<schxslt:pattern id="d17e141"/>
		<schxslt:pattern id="d17e154"/>
		<schxslt:pattern id="d17e163"/>
		<schxslt:pattern id="d17e176"/>
		<schxslt:pattern id="d17e189"/>
		<schxslt:pattern id="d17e203"/>
		<schxslt:pattern id="d17e216"/>
		<schxslt:pattern id="d17e229"/>
		<schxslt:pattern id="d17e240"/>
		<schxslt:pattern id="d17e251"/>
		<schxslt:pattern id="d17e268"/>
		<schxslt:pattern id="d17e286"/>
		<schxslt:pattern id="d17e305"/>
		<schxslt:pattern id="d17e324"/>
		<schxslt:pattern id="d17e343"/>
		<schxslt:pattern id="d17e362"/>
		<schxslt:pattern id="d17e381"/>
		<schxslt:pattern id="d17e404"/>
		<schxslt:pattern id="d17e417"/>
		<schxslt:pattern id="d17e430"/>
		<schxslt:pattern id="d17e445"/>
		<schxslt:pattern id="d17e458"/>
		<schxslt:pattern id="d17e471"/>
		<schxslt:pattern id="d17e485"/>
		<schxslt:pattern id="d17e498"/>
		<schxslt:pattern id="d17e511"/>
		<schxslt:pattern id="d17e530"/>
		<schxslt:pattern id="d17e545"/>
		<schxslt:pattern id="d17e559"/>
		<schxslt:pattern id="d17e572"/>
		<schxslt:pattern id="d17e581"/>
		<schxslt:pattern id="d17e592"/>
		<schxslt:pattern id="d17e611"/>
		<schxslt:pattern id="d17e630"/>
		<schxslt:pattern id="d17e642"/>
		<schxslt:pattern id="d17e651"/>
		<xsl:apply-templates mode="d17e103" select="/"/>
	</xsl:template>
	<xsl:template match="ListedData" priority="38" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e103">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e103']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R122 for context "ListedData" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(*/ID/concat(.,',',@collectionID))) ne count(*/ID/concat(.,',',@collectionID))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="WARNING" id="R122_uqstrc">
							<xsl:attribute name="test">count(distinct-values(*/ID/concat(.,',',@collectionID))) ne count(*/ID/concat(.,',',@collectionID))</xsl:attribute>
							<svrl:text>IDs haben den Aufzählungen von Anlagen, Teilströmen, usw. in ListedData nicht mehrfach zugeordnet zu sein - verletzt für IDs <xsl:value-of select="string-join((for $m in distinct-values(*/ID/concat(.,',',@collectionID)) return if (count(*/ID[(. eq tokenize($m,',')[1]) and (@collectionID eq tokenize($m,',')[2])]) ge 2) then tokenize($m,',')[1] else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e103')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/Organization" priority="37" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e114">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e114']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R141 for context "ListedData/Organization" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(ID[(@collectionID='9008390104026') or (@collectionID='9008390104040') or (@collectionID='9008390104057') or (@collectionID='9008390104064')]))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R141_prvalw">
							<xsl:attribute name="test">not(exists(ID[(@collectionID='9008390104026') or (@collectionID='9008390104040') or (@collectionID='9008390104057') or (@collectionID='9008390104064')]))</xsl:attribute>
							<svrl:text>Zu jeder nicht-natürlichen Person hat eine EDM-Personen-GLN, Firmenbuchnummer, Vereinsregisternummer oder Ergänzungsregisternummer angegeben zu sein - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Person<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e114')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/Organization" priority="36" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e128">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e128']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R161 for context "ListedData/Organization" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'PartyReferenceID') and (text() eq $m)]) lt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R161_chkref">
							<xsl:attribute name="test">some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'PartyReferenceID') and (text() eq $m)]) lt 1</xsl:attribute>
							<svrl:text>Auf jede (nicht-natürliche) Person hat in der Dateninstanz Bezug genommen zu werden - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Person<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e128')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/Organization" priority="35" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e141">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e141']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R166 for context "ListedData/Organization" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(CommunicationNetworkEndpoint/TypeID)) ne count(CommunicationNetworkEndpoint/TypeID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R166_uqstrc">
							<xsl:attribute name="test">count(distinct-values(CommunicationNetworkEndpoint/TypeID)) ne count(CommunicationNetworkEndpoint/TypeID)</xsl:attribute>
							<svrl:text>Je Kontaktart (Website-Adresse, Telefon, usw.) hat nicht mehr als eine Kontaktinformation angegeben zu werden (Element CommunicationNetworkEndpoint) - verletzt für Kontaktangaben zur <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Person<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e141')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="Document/TypeID" priority="34" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e154">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e154']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R202 for context "Document/TypeID" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="current()/text() eq '9008390120507'">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R202_chkval">
							<xsl:attribute name="test">current()/text() eq '9008390120507'</xsl:attribute>
							<svrl:text>Die XML-Dateninstanz enthält als Dokumentart-Angabe den Wert »9008390120507« für »Wasserwirtschaftliche Stammdaten und Bewegungsdaten«. Seit v0.33 der Datenformat-Spezifikation unterstützt das Datenformat nur noch die Dokument-Art »9008390120514« für »Wasserwirtschaftliche Bewegungsdaten«. Seit 2024 unterstützt die EMREG-OW-Anwendung die XML-Übermittlung von wasserwirtschaftlichen Stammdaten an die Bundesbehörde NICHT mehr.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e154')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/Installation" priority="33" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e163">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e163']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R217 for context "ListedData/Installation" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(count(ID) lt 1)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R217_prvalw">
							<xsl:attribute name="test">(count(ID) lt 1)</xsl:attribute>
							<svrl:text>Zu jeder Anlage hat zumindest eine Identifikationszeichenkette im Element ID angegeben zu sein - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltene Anlage<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e163')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/WasteWaterStream" priority="32" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e176">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e176']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R336 for context "ListedData/WasteWaterStream" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(ID[@collectionID='9008390108260']))">
						<svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R336_prvalw">
							<xsl:attribute name="test">exists(ID[@collectionID='9008390108260'])</xsl:attribute>
							<svrl:text>Zu jedem Teilstrom hat eine Wasserbuch-ID angegeben zu sein - verletzt für den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:failed-assert>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e176')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ListedData/WasteWaterStream" priority="31" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e189">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e189']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R352 for context "ListedData/WasteWaterStream" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'WasteWaterStreamReferenceID') and (text() eq $m)]) lt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R352_chkref">
							<xsl:attribute name="test">some $m in DocumentScopeAssignmentID satisfies count(//*[ends-with(local-name(), 'WasteWaterStreamReferenceID') and (text() eq $m)]) lt 1</xsl:attribute>
							<svrl:text>Auf jeden Teilstrom hat in der Dateninstanz Bezug genommen zu werden - verletzt für den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(Name)) then concat(' (Name: »',Name,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e189')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/InstallationReferencePeriodResult" priority="30" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e203">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e203']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R497 for context "EnvironmentalData/InstallationReferencePeriodResult" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(InstallationReferenceID) lt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R497_prvalw">
							<xsl:attribute name="test">count(InstallationReferenceID) lt 1</xsl:attribute>
							<svrl:text>Die Bezugszeitraum-spezifischen Angaben zu einer Anlage in InstallationReferencePeriodResult haben den Bezug auf eine Anlage im Element InstallationReferenceID zu enthalten - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Bezugszeitraum-Angaben (InstallationReferencePeriodResult) innerhalb der <xsl:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e203')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult" priority="29" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e216">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e216']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R520 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(WasteWaterStreamReferenceID) lt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R520_prvalw">
							<xsl:attribute name="test">count(WasteWaterStreamReferenceID) lt 1</xsl:attribute>
							<svrl:text>Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Eigenschaften in WasteWaterStreamReferencePeriodResult haben den Bezug auf einen Teilstrom im Element WasteWaterStreamReferenceID zu enthalten - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Bezugszeitraum-Angaben (WasteWaterStreamReferencePeriodResult) innerhalb der <xsl:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e216')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult" priority="28" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e229">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e229']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R522 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(EffluentWaterParameterProperty/PropertyKindID)) ne count(EffluentWaterParameterProperty/PropertyKindID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R522_uqstrc">
							<xsl:attribute name="test">count(distinct-values(EffluentWaterParameterProperty/PropertyKindID)) ne count(EffluentWaterParameterProperty/PropertyKindID)</xsl:attribute>
							<svrl:text>Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Abfluss-Eigenschaften in WasteWaterStreamReferencePeriodResult haben zu jedem Parameter höchstens einen Eintrag zu enthalten - verletzt für Abfluss-Bezugszeitraumangaben zu Parametern mit den IDs <xsl:value-of select="string-join((for $m in distinct-values(EffluentWaterParameterProperty/PropertyKindID) return if (count(EffluentWaterParameterProperty[PropertyKindID eq $m]) ge 2) then $m else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e229')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult" priority="27" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e240">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e240']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R523 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(InfluentWaterParameterProperty/PropertyKindID)) ne count(InfluentWaterParameterProperty/PropertyKindID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R523_uqstrc">
							<xsl:attribute name="test">count(distinct-values(InfluentWaterParameterProperty/PropertyKindID)) ne count(InfluentWaterParameterProperty/PropertyKindID)</xsl:attribute>
							<svrl:text>Die Angaben zu den für einen Teilstrom und den Bezugszeitraum ermittelten Zufluss-Eigenschaften in WasteWaterStreamReferencePeriodResult haben zu jedem Parameter höchstens einen Eintrag zu enthalten - verletzt für Zufluss-Bezugszeitraumangaben zu Parametern mit den IDs <xsl:value-of select="string-join((for $m in distinct-values(InfluentWaterParameterProperty/PropertyKindID) return if (count(InfluentWaterParameterProperty[PropertyKindID eq $m]) ge 2) then $m else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e240')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" priority="26" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e251">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e251']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R531 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(TestingCount)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R531_chkcon">
							<xsl:attribute name="test">some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(TestingCount)</xsl:attribute>
							<svrl:text>Für jeden Teilstrom und jeden Parameter in den Bewegungsdaten muss zutreffen, dass den Abfluss betreffend nicht sowohl die Anzahl der Einzelmesswerte angegeben ist (TestingCount-Element), als auch die Einzelmesswerte selbst (PropertyTesting-Element) - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den Parameter mit der ID »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e251')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" priority="25" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e268">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e268']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R532 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(ValueAssignmentStatement)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R532_chkcon">
							<xsl:attribute name="test">some $m in ../WasteWaterStreamReferenceID, $n in PropertyKindID satisfies exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq $m]/EffluentSampleTestingEvent/PropertyTesting[PropertyKindID eq $n]) and exists(ValueAssignmentStatement)</xsl:attribute>
							<svrl:text>Für jeden Teilstrom und jeden Parameter in den Bewegungsdaten muss zutreffen, dass den Abfluss betreffend nicht sowohl Bezugszeitraum-Angaben enthalten sind (EffluentWaterParameterProperty-Element mit ValueAssignmentStatement-Unterelement), als auch Einzelmesswerte (PropertyTesting-Element) - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den Parameter mit der ID »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e268')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" priority="24" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e286">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e286']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R538 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(PropertyCategoryID))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R538_prvalw">
							<xsl:attribute name="test">not(exists(PropertyCategoryID))</xsl:attribute>
							<svrl:text>Für den Abfluss betreffende Bezugszeitraum-Werte hat die Parameterkategorie (PropertyCategoryID-Element) angegeben zu sein - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Abfluss angegebenen Parameter (ID: »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e286')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" priority="23" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e305">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e305']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R542 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/EffluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(ValueAssignmentStatement)) and exists(../WasteWaterStreamReferenceID) and not(exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentSampleTestingEvent[f:strippedParamID(PropertyTesting/PropertyKindID) eq f:strippedParamID(current()/PropertyKindID)]))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R542_prvcdn">
							<xsl:attribute name="test">not(exists(ValueAssignmentStatement)) and exists(../WasteWaterStreamReferenceID) and not(exists(../../Testing/TestingEvent[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentSampleTestingEvent[f:strippedParamID(PropertyTesting/PropertyKindID) eq f:strippedParamID(current()/PropertyKindID)]))</xsl:attribute>
							<svrl:text>Für den Abfluss betreffende Bezugszeitraum-Angaben haben Werte angegeben zu sein (ValueAssignmentStatement-Element) sofern zum betreffenden Teilstrom und Parameter keine Einzeluntersuchungsergebnisse vorhanden sind - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Abfluss angegebenen Parameter (ID: »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e305')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" priority="22" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e324">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e324']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R569 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="exists(PropertyCategoryID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R569_prvalw">
							<xsl:attribute name="test">exists(PropertyCategoryID)</xsl:attribute>
							<svrl:text>Für den Zufluss betreffende Bezugszeitraum-Werte hat die Parameterkategorie (PropertyCategoryID-Element) nicht angegeben zu sein - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e324')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" priority="21" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e343">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e343']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R593 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(ValueAssignmentStatement))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R593_prvalw">
							<xsl:attribute name="test">not(exists(ValueAssignmentStatement))</xsl:attribute>
							<svrl:text>Für den Zufluss betreffende Bezugszeitraum-Angaben haben Werte angegeben zu sein (ValueAssignmentStatement-Element) - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e343')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" priority="20" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e362">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e362']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R595 for context "EnvironmentalData/WasteWaterStreamReferencePeriodResult/InfluentWaterParameterProperty" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="exists(CalculationBasisPeriod)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R595_prvalw">
							<xsl:attribute name="test">exists(CalculationBasisPeriod)</xsl:attribute>
							<svrl:text>Für den Zufluss betreffende Bezugszeitraum-Werte hat kein Berechnungsbasis-Messjahr (CalculationBasisPeriod-Element) angegeben zu sein - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zum Zufluss angegebenen Parameter (ID: »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(', Name: »',PropertyKindID/@objectDesignation,'«)') else ')'"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e362')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]" priority="19" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e381">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e381']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R597 for context "WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R597_prvcdn">
							<xsl:attribute name="test">(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt die Angabe von Werten für den gesamten Bezugszeitraum nur für solche Parameter, bei welchen es sich weder um “pH-Wert” noch um “Temperatur” handelt - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. zu diesem Teilstrom bezogen auf den <xsl:value-of select="if (ends-with(local-name(), 'EffluentWaterParameterProperty')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e381')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" priority="18" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e404">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e404']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R604 for context "EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in StartDate satisfies day-from-date($m) ne 1 or month-from-date($m) ne 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R604_chkval">
							<xsl:attribute name="test">some $m in StartDate satisfies day-from-date($m) ne 1 or month-from-date($m) ne 1</xsl:attribute>
							<svrl:text>Der <xsl:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat mit einem 1. Jänner zu beginnen - verletzt für Beginndatum »<xsl:value-of select="StartDate"/>«.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e404')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" priority="17" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e417">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e417']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R608 for context "EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in EndDate satisfies day-from-date($m) ne 31 or month-from-date($m) ne 12">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R608_chkval">
							<xsl:attribute name="test">some $m in EndDate satisfies day-from-date($m) ne 31 or month-from-date($m) ne 12</xsl:attribute>
							<svrl:text>Der <xsl:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat mit einem 31. Dezember zu enden - verletzt für Enddatum »<xsl:value-of select="EndDate"/>«.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e417')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" priority="16" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e430">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e430']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R610 for context "EnvironmentalDataDocument/Document/TemporalExtent/Period | EnvironmentalDataDocument/EnvironmentalData/WasteWaterStreamReferencePeriodResult/*[ends-with(local-name(), 'WaterParameterProperty')]/CalculationBasisPeriod" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="if (exists(StartDate) and exists(EndDate)) then (year-from-date(EndDate) ne year-from-date(StartDate)) else false()">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R610_chkval">
							<xsl:attribute name="test">if (exists(StartDate) and exists(EndDate)) then (year-from-date(EndDate) ne year-from-date(StartDate)) else false()</xsl:attribute>
							<svrl:text>Der <xsl:value-of select="if (local-name() eq 'Period') then 'Berichtszeitraum' else 'Bezugszeitraum'"/> hat sich nicht über ein Kalenderjahr hinaus zu erstrecken - verletzt für den Zeitraum »<xsl:value-of select="StartDate"/> bis <xsl:value-of select="EndDate"/>«.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e430')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="*[(ends-with(local-name(), 'Address') and Component)]" priority="15" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e445">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e445']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R692 for context "*[(ends-with(local-name(), 'Address') and Component)]" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(Component/TypeID)) ne count(Component/TypeID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R692_uqstrc">
							<xsl:attribute name="test">count(distinct-values(Component/TypeID)) ne count(Component/TypeID)</xsl:attribute>
							<svrl:text>In Adressangaben hat keine der Adresskomponenten (“Straße”, “Postleitzahl”, usw.) mehrfach vorzukommen - verletzt für Adress-Element »<xsl:value-of select="local-name(.)"/>« in »<xsl:value-of select="local-name(parent::*)"/>«.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e445')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="*[ends-with(local-name(), 'Address')]/Component" priority="14" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e458">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e458']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R694 for context "*[ends-with(local-name(), 'Address')]/Component" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="TypeID ne '9008390104682' and exists(ID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R694_chkcon">
							<xsl:attribute name="test">TypeID ne '9008390104682' and exists(ID)</xsl:attribute>
							<svrl:text>Die Identifikation einer Adresskomponente per ID-Element wird nur für die Adresskomponente “Land” (GTIN 9008390104682) unterstützt - verletzt für die Adresskomponente des Typs mit der GTIN »<xsl:value-of select="TypeID"/>«<xsl:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e458')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="*[ends-with(local-name(), 'Address')]/Component" priority="13" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e471">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e471']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R707 for context "*[ends-with(local-name(), 'Address')]/Component" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="exists(RepresentationID) and (TypeID ne '9008390103975' and TypeID ne '9008390103999' and TypeID ne '9008390104002' and TypeID ne '9008390104019' and TypeID ne '9008390103944')">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R707_chkcon">
							<xsl:attribute name="test">exists(RepresentationID) and (TypeID ne '9008390103975' and TypeID ne '9008390103999' and TypeID ne '9008390104002' and TypeID ne '9008390104019' and TypeID ne '9008390103944')</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt das Element RepresentationID ausschließlich in Adresskomponenten der Typen Hausnummer (GTIN 9008390103975), Stiege (GTIN 9008390103999), Stock (GTIN 9008390104002), Türnummer (GTIN 9008390104019) und Postleitzahl (GTIN 9008390103944) - verletzt für die Adresskomponente des Typs mit der GTIN »<xsl:value-of select="TypeID"/>«<xsl:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e471')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="*[ends-with(local-name(), 'Address')]/Component" priority="12" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e485">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e485']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R712 for context "*[ends-with(local-name(), 'Address')]/Component" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="exists(RepresentationDesignation) and (TypeID ne '9008390103968' and TypeID ne '9008390103951' and TypeID ne '9008390104682')">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R712_chkcon">
							<xsl:attribute name="test">exists(RepresentationDesignation) and (TypeID ne '9008390103968' and TypeID ne '9008390103951' and TypeID ne '9008390104682')</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt das Element RepresentationDesignation ausschließlich in Adresskomponenten der Typen Straße (GTIN 9008390103968), Ort (GTIN 9008390103951) und Land (GTIN 9008390104682) - verletzt für die Adresskomponente des Typs mit der GTIN »<xsl:value-of select="TypeID"/>«<xsl:value-of select="if (exists(TypeID/@objectDesignation)) then concat(' (»',TypeID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e485')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData" priority="11" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e498">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e498']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R767 for context "EnvironmentalData" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)) ne count(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R767_uqstrc">
							<xsl:attribute name="test">count(distinct-values(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)) ne count(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID)</xsl:attribute>
							<svrl:text>Die Bezugszeitraum-Angaben in WasteWaterStreamReferencePeriodResult haben nach Teilstrom gruppiert zu sein, d.h. auf denselben Teilstrom hat nicht mehrfach Bezug genommen zu werden - verletzt für Zeitraum-Angaben mit Bezug auf Teilströme mit Wasserbuch-IDs <xsl:value-of select="string-join((for $m in distinct-values(WasteWaterStreamReferencePeriodResult/WasteWaterStreamReferenceID) return if (count(WasteWaterStreamReferencePeriodResult[WasteWaterStreamReferenceID eq $m]) ge 2) then ancestor::*/ListedData/WasteWaterStream[DocumentScopeAssignmentID eq $m]/ID[@collectionID eq '9008390108260'] else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e498')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/Testing/TestingEvent[exists(WasteWaterStreamReferenceID)]/EffluentSampleTestingEvent[not(f:isPhProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(f:isTemperatureProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(exists(preceding-sibling::EffluentSampleTestingEvent[PropertyTesting/PropertyKindID/text() eq current()/PropertyTesting/PropertyKindID/text()]))]" priority="10" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e511">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e511']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R808 for context "EnvironmentalData/Testing/TestingEvent[exists(WasteWaterStreamReferenceID)]/EffluentSampleTestingEvent[not(f:isPhProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(f:isTemperatureProperty(f:strippedParamID(PropertyTesting/PropertyKindID/text()))) and not(exists(preceding-sibling::EffluentSampleTestingEvent[PropertyTesting/PropertyKindID/text() eq current()/PropertyTesting/PropertyKindID/text()]))]" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not(exists(../../../WasteWaterStreamReferencePeriodResult[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentWaterParameterProperty[(f:strippedParamID(PropertyKindID) eq f:strippedParamID(current()/PropertyTesting/PropertyKindID)) and (count(PropertyCategoryID) gt 0)]))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R808_prvcdn">
							<xsl:attribute name="test">not(exists(../../../WasteWaterStreamReferencePeriodResult[WasteWaterStreamReferenceID eq current()/../WasteWaterStreamReferenceID]/EffluentWaterParameterProperty[(f:strippedParamID(PropertyKindID) eq f:strippedParamID(current()/PropertyTesting/PropertyKindID)) and (count(PropertyCategoryID) gt 0)]))</xsl:attribute>
							<svrl:text>Für jeden Abfluss-Einzelmesswert hat über in Bezug auf Teilstrom und Parameter <xsl:value-of select="f:strippedParamID(PropertyTesting/PropertyKindID/text())"/> korrespondierende Bezugszeitraum-Angaben (WasteWaterStreamReferencePeriodResult) die Parameterkategorie im Element PropertyCategoryID angegeben zu sein - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den Abfluss angegebenen Parameter mit der ID »<xsl:value-of select="PropertyTesting/PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyTesting/PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyTesting/PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e511')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="Testing/TestingEvent" priority="9" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e530">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e530']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R809 for context "Testing/TestingEvent" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="some $m in distinct-values(EffluentSampleTestingEvent/PropertyTesting/PropertyKindID) satisfies count(EffluentSampleTestingEvent[PropertyTesting/PropertyKindID eq $m]) gt 12">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R809_chkmlt">
							<xsl:attribute name="test">some $m in distinct-values(EffluentSampleTestingEvent/PropertyTesting/PropertyKindID) satisfies count(EffluentSampleTestingEvent[PropertyTesting/PropertyKindID eq $m]) gt 12</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt die Angabe von nicht mehr als 12 Abfluss-Einzelmesswerten pro Berichtsjahr, Teilstrom und Parameter - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und die Parameter mit den IDs <xsl:value-of select="string-join((for $m in distinct-values(EffluentSampleTestingEvent/PropertyTesting/PropertyKindID) return if (count(EffluentSampleTestingEvent[PropertyTesting/PropertyKindID eq $m]) gt 12) then tokenize($m,',')[1] else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e530')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="Testing/TestingEvent" priority="8" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e545">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e545']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R828 for context "Testing/TestingEvent" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="InfluentSampleTestingEvent">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R828_chkcon">
							<xsl:attribute name="test">InfluentSampleTestingEvent</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt die Übermittlung von einzelnen Untersuchungsergebnissen nur für den Abfluss - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und den zu diesem Teilstrom angegebenen Zufluss-Parametern.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e545')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="Testing/TestingEvent" priority="7" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e559">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e559']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R832 for context "Testing/TestingEvent" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(WasteWaterStreamReferenceID) lt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R832_prvalw">
							<xsl:attribute name="test">count(WasteWaterStreamReferenceID) lt 1</xsl:attribute>
							<svrl:text>Die Angaben zu den einzelnen Wasseruntersuchungen und deren Ergebnissen haben den Bezug auf einen Teilstrom im Element WasteWaterStreamReferenceID zu enthalten - verletzt für die <xsl:value-of select="1+count(preceding-sibling::*[name() eq name(current())])"/>. Untersuchungsergebnis-Angaben (TestingEvent) innerhalb der <xsl:value-of select="1+count(ancestor::EnvironmentalDataDocument/preceding-sibling::*[local-name() eq 'EnvironmentalDataDocument'])"/>. wasserwirtschaftlichen Bewegungsdaten (EnvironmentalDataDocument) in der XML-Instanz.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e559')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/Testing" priority="6" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e572">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e572']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R874 for context "EnvironmentalData/Testing" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(AppliedMethod) ge 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R874_prvalw">
							<xsl:attribute name="test">count(AppliedMethod) ge 1</xsl:attribute>
							<svrl:text>Bei der Übermittlung in EMREG-OW wird für Einzelmesswerte eine Angabe von Methoden nicht unterstützt.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e572')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="EnvironmentalData/Testing" priority="5" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e581">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e581']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R875 for context "EnvironmentalData/Testing" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(TestingEvent/WasteWaterStreamReferenceID)) ne count(TestingEvent/WasteWaterStreamReferenceID)">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R875_uqstrc">
							<xsl:attribute name="test">count(distinct-values(TestingEvent/WasteWaterStreamReferenceID)) ne count(TestingEvent/WasteWaterStreamReferenceID)</xsl:attribute>
							<svrl:text>Die Angaben zu einzelnen Untersuchungen in Testing/TestingEvent haben nach Teilstrom gruppiert zu sein, d.h. auf denselben Teilstrom hat nicht mehrfach Bezug genommen zu werden - verletzt für Untersuchungsangaben mit Bezug auf Teilströme mit Wasserbuch-IDs <xsl:value-of select="string-join((for $m in distinct-values(TestingEvent/WasteWaterStreamReferenceID) return if (count(TestingEvent[WasteWaterStreamReferenceID eq $m]) ge 2) then ancestor::*/ListedData/WasteWaterStream[DocumentScopeAssignmentID eq $m]/ID[@collectionID eq '9008390108260'] else '')[. != ''], ', ')"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e581')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting" priority="4" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e592">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e592']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R909 for context "TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R909_chkcon">
							<xsl:attribute name="test">(f:isPhProperty(PropertyKindID/text()) eq true()) or (f:isTemperatureProperty(PropertyKindID/text()) eq true())</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt die Übermittlung von einzelnen Untersuchungsergebnissen in EMREG-OW nur für solche Parameter, bei welchen es sich weder um “pH-Wert” noch um “Temperatur” handelt - verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den <xsl:value-of select="if (ends-with(local-name(..), 'EffluentSampleTestingEvent')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e592')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting" priority="3" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e611">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e611']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R916 for context "TestingEvent/*[ends-with(local-name(), 'SampleTestingEvent')]/PropertyTesting" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(count(ValueAssignmentStatement/NumericValue[not(exists(@unitID))]) ge 1) or (some $m in ValueAssignmentStatement/NumericValue/@unitID satisfies (($m ne 'mg/l') and ($m ne 'ug/l') and ($m ne 'ng/l')))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R916_chkval">
							<xsl:attribute name="test">(count(ValueAssignmentStatement/NumericValue[not(exists(@unitID))]) ge 1) or (some $m in ValueAssignmentStatement/NumericValue/@unitID satisfies (($m ne 'mg/l') and ($m ne 'ug/l') and ($m ne 'ng/l')))</xsl:attribute>
							<svrl:text>Das Datenformat unterstützt die für die Übermittlung von Untersuchungsergebnissen in die Anwendung EMREG-OW ausschließlich die Angabe der Größeneinheiten “mg/l”, “µg/l” bzw. “ng/l”- verletzt für den <xsl:value-of select="1+count((//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID])/../preceding-sibling::*[local-name() eq 'WasteWaterStream'])"/>. in der XML-Instanz enthaltenen Teilstrom<xsl:value-of select="if (exists(//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name)) then concat(' (Name: »',//ListedData/WasteWaterStream[DocumentScopeAssignmentID eq current()/../../WasteWaterStreamReferenceID]/Name,'«)') else ''"/> und dem zu diesem Teilstrom bezogen auf den <xsl:value-of select="if (ends-with(local-name(..), 'EffluentSampleTestingEvent')) then 'Abfluss' else 'Zufluss'"/> angegebenen Parameter mit der ID »<xsl:value-of select="PropertyKindID"/>«<xsl:value-of select="if (exists(PropertyKindID/@objectDesignation)) then concat(' (Name: »',PropertyKindID/@objectDesignation,'«)') else ''"/>.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e611')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ed:EnvironmentalDataEnvelope" priority="2" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e630">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e630']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R948 for context "ed:EnvironmentalDataEnvelope" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(EnvironmentalDataDocument) ne 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R948_chkmlt">
							<xsl:attribute name="test">count(EnvironmentalDataDocument) ne 1</xsl:attribute>
							<svrl:text>Der Datenimport in EMREG-OW ist jeweils nur für genau ein Berichtsjahr möglich, und somit jeweils genau ein EnvironmentalDataDocument-Element. Es sind jedoch <xsl:value-of select="count(EnvironmentalDataDocument)"/> EnvironmentalDataDocument-Elemente in der Dateninstanz enthalten.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e630')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="ed:EnvironmentalDataEnvelope" priority="1" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e642">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e642']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R956 for context "ed:EnvironmentalDataEnvelope" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(distinct-values(//PropertyKindID/@collectionID)) gt 1">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R956_chkcon">
							<xsl:attribute name="test">count(distinct-values(//PropertyKindID/@collectionID)) gt 1</xsl:attribute>
							<svrl:text>Innerhalb einer XML-Dateninstanz haben alle Parameter entweder per EHPC-Code (Codeliste 6912) oder per GTIN (Codeliste 2809) angegeben zu sein, und zwar über die verschiedenen Angaben - z.B. Grenzwert, Jahreswert, Messwert - hinweg. Das “Mischen” von EHPC-Codes und GTINs innerhalb einer XML-Dateninstanz wird vom Datenformat nicht unterstützt.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e642')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:template match="//*[ends-with(local-name(), 'ID') and (count(preceding-sibling::*[name() eq name(current())]) eq 0)]" priority="0" mode="d17e103">
		<xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
		<schxslt:rule pattern="d17e651">
			<xsl:choose>
				<xsl:when test="$schxslt:patterns-matched[. = 'd17e651']">
					<xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule R978 for context "//*[ends-with(local-name(), 'ID') and (count(preceding-sibling::*[name() eq name(current())]) eq 0)]" shadowed by preceding rule</xsl:comment>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(not(ends-with(local-name(), 'ReferenceID'))) and (local-name() ne 'AuthorityAssignedID') and (local-name() ne 'CadastralParcelID') and (local-name() ne 'CadastralPropertyID') and (local-name() ne 'SewageTreatmentStageID') and (local-name() ne 'MunicipalityID') and (local-name() ne 'OriginInstallationIPPCActivityID') and (local-name() ne 'OriginInstallationActivityID') and (local-name() ne 'ActivityID') and (local-name() ne 'LegalBasisID') and (local-name() ne 'CadastralMunicipalityID') and (count(distinct-values(../*[name() eq name(current())]/@collectionID)) ne count(../*[name() eq name(current())]/@collectionID))">
						<svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" location="{schxslt:location(.)}" role="ERROR" id="R978_uqelem">
							<xsl:attribute name="test">(not(ends-with(local-name(), 'ReferenceID'))) and (local-name() ne 'AuthorityAssignedID') and (local-name() ne 'CadastralParcelID') and (local-name() ne 'CadastralPropertyID') and (local-name() ne 'SewageTreatmentStageID') and (local-name() ne 'MunicipalityID') and (local-name() ne 'OriginInstallationIPPCActivityID') and (local-name() ne 'OriginInstallationActivityID') and (local-name() ne 'ActivityID') and (local-name() ne 'LegalBasisID') and (local-name() ne 'CadastralMunicipalityID') and (count(distinct-values(../*[name() eq name(current())]/@collectionID)) ne count(../*[name() eq name(current())]/@collectionID))</xsl:attribute>
							<svrl:text>Bei wiederholbaren ID-Elementen ist in vielen Fällen nur ein Eintrag pro Codeliste bzw. Sammlung von Identifikatoren zulässig - verletzt für Element »<xsl:value-of select="local-name(.)"/>« in »<xsl:value-of select="local-name(parent::*)"/>«.</svrl:text>
						</svrl:successful-report>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</schxslt:rule>
		<xsl:next-match>
			<xsl:with-param name="schxslt:patterns-matched" as="xs:string*" select="($schxslt:patterns-matched, 'd17e651')"/>
		</xsl:next-match>
	</xsl:template>
	<xsl:function name="schxslt:location" as="xs:string">
		<xsl:param name="node" as="node()"/>
		<xsl:variable name="segments" as="xs:string*">
			<xsl:for-each select="($node/ancestor-or-self::node())">
				<xsl:variable name="position">
					<xsl:number level="single"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test=". instance of element()">
						<xsl:value-of select="concat('Q{', namespace-uri(.), '}', local-name(.), '[', $position, ']')"/>
					</xsl:when>
					<xsl:when test=". instance of attribute()">
						<xsl:value-of select="concat('@Q{', namespace-uri(.), '}', local-name(.))"/>
					</xsl:when>
					<xsl:when test=". instance of processing-instruction()">
						<xsl:value-of select="concat('processing-instruction(&quot;', name(.), '&quot;)[', $position, ']')"/>
					</xsl:when>
					<xsl:when test=". instance of comment()">
						<xsl:value-of select="concat('comment()[', $position, ']')"/>
					</xsl:when>
					<xsl:when test=". instance of text()">
						<xsl:value-of select="concat('text()[', $position, ']')"/>
					</xsl:when>
					<xsl:otherwise/>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="concat('/', string-join($segments, '/'))"/>
	</xsl:function>
</xsl:transform>
